IF EXISTS (SELECT * FROM SYS.OBJECTS WHERE NAME = 'UFD_CG_RETORNA_SALDO_USO_FORN')
	DROP FUNCTION [dbo].[UFD_CG_RETORNA_SALDO_USO_FORN]
GO
GO

CREATE FUNCTION [dbo].[UFD_CG_RETORNA_SALDO_USO_FORN] (@CD_EMP		INT, 
														@CD_VERBA		INT,
														@CD_FORN		INT,
														@DATA			DATETIME)	

RETURNS @RS_RETORNO TABLE (	SLD_USO		MONEY)

AS
BEGIN

	INSERT INTO @RS_RETORNO
	SELECT SUM(SLD_USO) SLD_USO
	FROM
	(
	SELECT
		SUM(P.VLR_VERBA_TOT) AS SLD_USO
	FROM 

		CG_FND_VERBA V
		LEFT JOIN CG_FND_VERBA_PROD P ON
		V.CD_EMP = P.CD_EMP AND
		V.CD_FND_VERBA = P.CD_FND_VERBA
	WHERE
		V.CD_EMP=@CD_EMP
		AND V.CD_FND_VERBA= @CD_VERBA
		AND V.CD_FORN = @CD_FORN
		AND P.DT_CAD <= @DATA
	UNION ALL

	SELECT 
		(SUM(S.VLR_SAQUE)) AS SLD_USO
	FROM 

		CG_FND_VERBA V
		LEFT JOIN CG_FND_VERBA_SAQUE S ON
		V.CD_EMP = S.CD_EMP AND
		V.CD_FND_VERBA = S.CD_FND_VERBA
		
	WHERE
		V.CD_EMP=@CD_EMP
		AND V.CD_FND_VERBA= @CD_VERBA
		AND V.CD_FORN = @CD_FORN
		AND S.STATUS=0
		AND S.DT_SAQUE <= @DATA
		) AS TBL
RETURN
END
GO


